<?php
	include("connect.inc.php");
	include("functions.inc.php");

	date_default_timezone_set('Africa/Dar_es_Salaam');

	// password_hash($password, PASSWORD_BCRYPT);

	if (isset($_POST['page']) && isset($_POST['action'])) {
		$page = $_POST['page'];
		$action = $_POST['action'];

		if ($page == "admin") {
			if ($action == "login") {
				session_destroy();

				$uname = strip_tags(stripslashes($conn->real_escape_string($_POST["uname"])));
				$password = strip_tags(stripslashes($conn->real_escape_string($_POST["password"])));

				$salt1 = "ELIMIKA";
				$salt2 = "DIGITAL";
				$password = crypt($password, $salt1);
				$password = $salt1.md5($password).$salt2;

				//check for usernames
				$query = $conn->query("SELECT * FROM `users` WHERE `phone`='$uname' OR `FirstName`='$uname'");
				$row = $query->num_rows;

				if ($row == 1) {
					$fetch = $query->fetch_assoc();
					$upass = $fetch['upass'];

					if (password_verify($password, $upass)) {
						session_start();

						$uid = $fetch['UID'];
						$access = $fetch['Access'];
						$names = $fetch['FirstName']." ".$fetch['LastName'];

						if ($access == "Admin") {

							$_SESSION['userID'] = $uid;
							$_SESSION['Access'] = $access;
							$_SESSION['names'] = $names;

							header("Location: ../admin/");
						}
					} else {
						header("Location: ../login/?logErr=Xas12");
					}
				}
			}

			if($action == "classes") {
				
				if ($_POST['function'] == "addClasses") {
					$className = stripslashes(strip_tags($conn->real_escape_string($_POST['className'])));
					$level = stripslashes(strip_tags($conn->real_escape_string($_POST['level'])));

					$query = $conn->query("SELECT * FROM `classes` WHERE `Class_Name`='$className' AND `Level`='$level'");
					$rows = $query->num_rows;

					if ($rows < 1) {
						$query = $conn->query("INSERT INTO `classes` (`Class_Name`, `Level`) VALUES ('$className', '$level')");

						echo "<span class='text text-success fw-bold'>$className added Successfully <i class='fa fa-check'></i></span>";
					} else {
						echo "<span class='text text-warning fw-bold'>$className already exists <i class='text-danger fa fa-times fw-bold'></i></span>";
					}
				}

				if ($_POST['function'] == "classesAction") {
					?>
					<div class="row mt-2 mb-2">
						<div class="col-sm-4 col-md-4">
							<button type="button" class="btn btn-info btn-sm fw-bold w-100" id="showClasses">
								<i class="fa fa-eye"></i>
								Show Classes
							</button>	
						</div>
						<div class="col-sm-4 col-md-4">
							<button type="button" class="btn btn-info btn-sm fw-bold w-100" id="showSubjects">
								<i class="fa fa-eye"></i>
								Show Subjects
							</button>	
						</div>
					</div>
					<div class="form-group" id="classesContainer"></div>
					<div id="errMsg"></div>
					<?php
				}

				if ($_POST['function'] == "classAction"){
					$classID = strip_tags(stripslashes($conn->real_escape_string($_POST['classID'])));

					$query = $conn->query("SELECT `Class_Name` FROM `classes` WHERE `Class_ID`='$classID'");
					$fetch = $query->fetch_assoc();
					$name = $fetch['Class_Name'];

					$query = $conn->query("DELETE FROM `classes` WHERE `Class_ID`='$classID'");

					echo "<span class=\"text-success fw-bold\">".$name." Deleted Successfully.</span>";
				}

				if ($_POST['function'] == "viewClasses") {
					$query = $conn->query("SELECT * FROM `classes` ORDER BY Class_Name ASC");

					$no = 0;

					?>
					<div class="table-responsive">						
						<form class="form mb-3 mt-3" id="addClassForms">
							<div class="row">
								<div class="col-sm-4 col-md-4">
									<div class="form-floating ">
										<input type="text" name="className" id="floatingInput" class="form-control form-control-sm" autocomplete="OFF">
										<label for="floatingInput">Class Name</label>
									</div>
								</div>
								<div class="col-sm-4 col-md-4">
									<div class="form-floating ">
										<select name="level" id="floatingSelect" class="form-select form-select sm">
											<option></option>
											<option value="Primary">Primary School</option>
											<option value="Secondary">Secondary School</option>
										</select>
										<label for="floatingSelect">School Level</label>
									</div>
								</div>
								<input type="hidden" name="page" value="admin">
								<input type="hidden" name="action" value="classes">
								<input type="hidden" name="function" value="addClasses">
								<div class="col-md-4 col-sm-4">
									<button type="submit" class="btn btn-outline-info"> <i class="fa fa-plus"></i> Add Class</button>
								</div>
							</div>
						</form>

						<table class="table mb-3">
							<thead>
								<tr>
									<th>S/No</th>
									<th>Class</th>
									<th>Level</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
								while ($fetch = $query->fetch_assoc()) {
									$classID = $fetch['Class_ID'];
									$className = $fetch['Class_Name'];
									$level = $fetch['Level'];
									$no = $no + 1;
									?>
									<tr>
										<td>
											<?php echo $no; ?>
										</td>
										<td>
											<?php echo $className; ?>
										</td>
										<td>
											<?php echo $level; ?>
										</td>
										<td>
											<div class="row">
												<div class="col-md-6 col-sm-6">
													<button type="button" class="w-100 fw-bold btn btn-outline-warning btn-sm edit" id="<?php echo $classID; ?>">
														<i class="fa fa-edit"></i>
														Edit
													</button>
												</div>
												<div class="col-md-6 col-sm-6">
													<button type="button" class="w-100 fw-bold btn btn-outline-danger btn-sm del" id="<?php echo $classID; ?>">
														<i class="fa fa-trash"></i>
														Delete
													</button>
												</div>
											</div>
										</td>
									</tr>
									<?php
								}
								?>
							</tbody>
						</table>
					</div>
					<?php
				}

				if ($_POST['function'] == "editSubject") {
					$subjectName = strip_tags(stripslashes($conn->real_escape_string($_POST['subjectName'])));
					$classes = implode(",", $_POST['classes']);
					$subjectID = strip_tags(stripslashes($conn->real_escape_string($_POST['subjectID'])));
					$time = strip_tags(stripslashes($conn->real_escape_string($_POST['subjectTime'])));

					$query = $conn->query("UPDATE `subjects` SET `Subject_Name`='$subjectName', `Class_IDs`='$classes', `subjectTime`='$time' WHERE `Subject_ID`='$subjectID'");

					echo "<span class=\"text-warning fw-bold\">".$subjectName." updated successfully.";

				}

				if($_POST['function'] == "deleteSubject") {
					$subjectID = stripslashes(strip_tags($conn->real_escape_string($_POST['subjectID'])));

					$query = $conn->query("SELECT * FROM `subjects` WHERE `Subject_ID`='$subjectID'");
					
					$rows = $query->num_rows;

					if($rows > 0){
						$fetch = $query->fetch_assoc();
						$subject = $fetch['Subject_Name'];

						$query = $conn->query("DELETE FROM `subjects` WHERE `Subject_ID`='$subjectID'");

						echo "<span class=\"text-danger fw-bold\">".$subject." deleted successfully.</span>";
					} else {
						echo "<span class=\"text-danger fw-bold\">Subject not in database.</span>";
					}
				}

				if ($_POST['function'] == "viewSubjects") {
					$query = $conn->query("SELECT * FROM `subjects` ORDER BY `Subject_Name` ASC");
					?>
					<div class="table-response">
						<form class="form mb-3 mt-3" id="addSubjectForms">
							<div class="row">
								<div class="col-sm-3 col-md-3">
									<div class="form-floating ">
										<input type="text" name="subjectName" id="floatingInput" class="form-control form-control-sm bg-dark text-white fw-bold" autocomplete="OFF" autocapitalize="ON">
										<label for="floatingInput">Subject Name</label>
									</div>
								</div>
								<div class="col-sm-3 col-md-3">
									<div class="row">
										<?php
											classesCheckBox();
										?>
									</div>
								</div>
								<div class="col-sm-3 col-md-3">
									<div class="form-floating">
										<input type="number" name="subjectTime" id="subjectTime" class="form-control bg-dark text-white" autocomplete="OFF">
										<label for="floatingInput" class="fw-bold">Subject Time(minutes)</label>
									</div>
								</div>
								<input type="hidden" name="page" value="admin">
								<input type="hidden" name="action" value="classes">
								<input type="hidden" name="function" value="addSubjects">
								<div class="col-md-3 col-sm-3">
									<button type="submit" class="btn btn-outline-info"> <i class="fa fa-plus"></i> Add Subject</button>
								</div>
							</div>
						</form>

						<hr>

						<?php
							$no = 0;

							while ($fetch = $query->fetch_assoc()) {
								$subjectID = $fetch['Subject_ID'];
								$subjectName = $fetch['Subject_Name'];
								$class = $fetch['Class_IDs'];
								$time = $fetch['subjectTime'];
								$no  = $no + 1;

							?>
							<div class="form">
								<form class="form mt-2 editSubject" id="<?php echo $subjectID; ?>">
									<div class="row">
										<div class="col-sm-2 col-md-2">
											<?php
												echo $no;
											?>
										</div>
										<div class="col-sm-3 col-md-3">
											<div class="form-floating w-100">
												<input type="text" class="form-control form-control-sm" name="subjectName" value="<?php echo $subjectName; ?>">
												<label for="floatingInput">Subject Name</label>
											</div>
										</div>
										<div class="col-sm-2 col-md-2">
											<?php
												$classQuery = $conn->query("SELECT * FROM `classes` ORDER BY `Class_Name` ASC");
												
												while($fetchClass = $classQuery->fetch_assoc()){
													$classID = $fetchClass['Class_ID'];
													$className = $fetchClass['Class_Name'];

													?>

													<input type="checkbox" class='form-check-input' name="classes[]" value='<?php echo $classID; ?>' id='flexCheckDefault' <?php if(strpos($class, $classID) !== false){ echo "checked"; } ?>>
													<label class='form-check-label' for='flexCheckDefault'><?php echo $className; ?></label>
													<br>
													
													<?php
												}
											?>
										</div>

										<div class="col-sm-2 col-md-2">
											<div class="form-floating w-100">
												<input type="text" name="subjectTime" id="subjectTime" class="form-control w-100" value="<?php echo $time; ?>">
												<label for="floatingInput">Time</label>
											</div>
										</div>

										<input type="hidden" name="page" value="admin">
										<input type="hidden" name="action" value="classes">
										<input type="hidden" name="function" value="editSubject">
										<input type="hidden" name="subjectID" value="<?php echo $subjectID; ?>">

										<div class="col-sm-3 col-md-3">
											<button type="submit" class="btn btn-sm btn-outline-warning mb-2" id="<?php echo $subjectID; ?>">
												<i class="fa fa-edit"></i>
												Edit
											</button>
											<button type="button" class="btn btn-sm btn-outline-danger mb-2 delete" id="<?php echo $subjectID; ?>">
												<i class="fa fa-trash"></i>
												Delete
											</button>
										</div>
									</div>
								</form>
								<hr>
							</div>
							<?php

							}
						?>
					</div>
					<?php
				}

				if ($_POST['function'] == "addSubjects") {
					$subjectName = ucfirst(stripslashes(strip_tags($conn->real_escape_string($_POST['subjectName']))));
					$time = strip_tags(stripslashes($conn->real_escape_string($_POST['subjectTime'])));
					$classes = implode(',', $_POST['classes']);

					$query = $conn->query("SELECT * FROM `subjects` WHERE `Subject_Name`='$subjectName'");
					
					if ($query->num_rows >= 1) {
						$fetch = $query->fetch_assoc();
						$id = $fetch['Subject_ID'];
						$old = $fetch['Class_IDs'];

						$old_array = explode(',', $old);
						$new_array = explode(',', $classes);

						// check for difference
						if($to_update_array = array_diff($new_array, $old_array)){

							// Convert the array back to a comma-separated string
							$to_update = implode(",", $to_update_array);

							$new = $to_update.",".$old;

							$query = $conn->query("UPDATE `subjects` SET `Class_IDs`='$new', `subjectTime`='$time' WHERE `Subject_ID`='$id'");

							echo "<span class=\"text-warning fw-bold\"><i class=\"text-success fa fa-check\"></i>  Subject Updated</span>";
						} else {
							echo "<span class=\"text-danger fw-bold\"><i class=\"text-danger fa fa-times\"></i>  Subject Already Exists</span>";
						}
					} else {
						$query = $conn->query("INSERT INTO `subjects` (`Subject_Name`, `Class_IDs`, `subjectTime`) VALUES ('$subjectName', '$classes', '$time')");

						echo "<span class=\"text-success fw-bold\">Subject Added Successfully</span>";
					}

				}

				if ($_POST['function'] == "editClass") {
					$classID = stripslashes(strip_tags($conn->real_escape_string($_POST['classID'])));
					$className = stripslashes(strip_tags($conn->real_escape_string($_POST['className'])));
					$level = ucfirst(stripslashes(strip_tags($conn->real_escape_string($_POST['level']))));

					$query = $conn->query("UPDATE `classes` SET `Class_Name`='$className', `Level`='$level' WHERE `Class_ID`='$classID'");

					echo "<span class=\"text text-primary fw-bold\">";
					echo $className." Updated successfully.";
					echo "</span>";
				}

				if ($_POST['function'] == "editClassForm") {
					$ID = stripslashes(strip_tags($conn->real_escape_string($_POST['ID'])));

					$query = $conn->query("SELECT * FROM `classes` WHERE `Class_ID`='$ID'");
					$fetch = $query->fetch_assoc();

					$className = $fetch['Class_Name'];
					$level = $fetch['Level'];

					?>
					<div class="modal-dialog">
						<div class="modal-content">
							<form id="editClass">
								<div class="modal-header">
									<h4 class="modal-title">Edit Classes</h4>
									<button type="button" class="close btn btn-outline-danger btn-sm fw-bold" data-dismiss="modal">
										<i class="fa fa-times"></i>
									</button>
								</div>
								<div class="modal-body">
									<div class="row">
										<div class="col-sm-6 col-md-6">
											<div class="form-floating">
												<input type="text" name="className" id="className" class="form-control form-control-sm" value="<?php echo $className; ?>" autocomplete="OFF">
												<label for="formInput">Class Name</label>
											</div>
										</div>
										<input type="hidden" name="page" value="admin">
										<input type="hidden" name="action" value="classes">
										<input type="hidden" name="function" value="editClass">
										<input type="hidden" name="classID" value="<?php echo $ID; ?>">
										<div class="col-sm-6 col-md-6">
											<div class="form-floating">
												<select name="level" id="level" class="form-select form-select-sm">
													<option value="Primary" <?php if($level == "Primary") { echo "selected"; } ?>>Primary</option>
													<option value="Secondary" <?php if($level == "Secondary") { echo "selected"; } ?>>Secondary</option>
												</select>
												<label for="formInput">Class Level</label>
											</div>
										</div>
									</div>
								</div>
								<div class="modal-footer">
									<p class="text-end" id="errorResponse"></p>
									<button type="submit" class="btn btn-outline-success btn-sm fw-bold"><i class="fa fa-edit"></i> Edit</button>
									<button type="button" class="btn btn-outline-danger btn-sm fw-bold close"><i class="fa fa-times"></i> Close</button>
								</div>
							</form>
						</div>
					</div>
					<?php
				}
			}

			if($action == "users") {

				if($_POST['function'] == "userAction"){
					?>

					<div class="row mb-2">
						<div class="col-sm-4 col-md-4">
							<button type="button" class="btn btn-info btn-sm fw-bold w-100" id="showUsers">
								<i class="fa fa-eye"></i>
								Show Users
							</button>	
						</div>
						<div class="col-sm-4 col-md-4">
							<button type="button" class="btn btn-info btn-sm fw-bold w-100" id="addUserForm">
								<i class="fa fa-user-plus"></i>
								Add Users
							</button>	
						</div>
					</div>

					<div class="form-group" id="userContainer"></div>
					<?php
				}

				if ($_POST['function'] == "showUsers") {
					$query = $conn->query("SELECT * FROM `users` ORDER BY `Access` ASC");
					$no = 0;
					?>
					<div class="table-response">
						<table class="table">
							<thead>
								<tr>
									<th>S/No</th>
									<th>Names</th>
									<th>Access</th>
									<th>Class</th>
									<th>Subject</th>
									<th>Contact</th>
								</tr>
							</thead>
							<tbody>
					<?php

					while ($fetch = $query->fetch_assoc()) {
						$no = $no + 1;
						$names = $fetch['FirstName']." ".$fetch['LastName'];
						$access = $fetch['Access'];
						$phone = $fetch['Phone'];
						$uid = $fetch['UID'];

						?>
						<tr>
							<td><?php echo $no; ?></td>
							<td><?php echo $names; ?></td>
							<td><?php echo $access; ?></td>
						<?php

						if ($access == "Teacher") {
							$tQuery = $conn->query("SELECT * FROM `teachers` WHERE `UID`='$uid'");
							$fetchT = $tQuery->fetch_assoc();
							$subjectIDs = $fetchT['Subject_IDs'];
							$classIDs = $fetchT['Class_IDs'];
							$exams = $fetchT['Exams_Created'];
							?>
							<td><?php echo $classIDs; ?></td>
							<td><?php echo $subjectIDs; ?></td>
							<?php
						}
						?>
							<td class="text text-danger fw-bold">Null</td>
							<td class="text text-danger fw-bold">Null</td>
							<td>
								<a href="tel:<?php echo $phone; ?>" class="btn btn-sm btn-outline-warning fw-bold">
									<i class="fa fa-phone rotate-180"></i>
									<!-- <i class="fa fa-phone-square rotate-180"></i> -->
									Call
								</a>
							</td>
						</tr>
						<?php
					}
					?>
							</tbody>
						</table>
					</div>
					<?php
				}

				if ($_POST['function'] == "addUserForm") {
					?>					

					<form class="form" id="addUsersForm">
						<div class="row mt-2">
							<div class="col-md-4 col-sm-4"> <hr> </div>
							<div class="col-md-4 col-sm-4 text-center">
								<h5>User Details</h5>
							</div>
							<div class="col-md-4 col-sm-4"> <hr> </div>
						</div>
						<div class="row mt-2">
							<div class="col-md-6 col-sm-6 mb-3">
								<input type="text" name="fname" id="fname" class="form-control form-control-sm" autocomplete="OFF" placeholder="First Name">
							</div>
							<div class="col-md-6 col-sm-6 mb-3">
								<input type="text" name="lname" id="lname" class="form-control form-control-sm" autocomplete="OFF" placeholder="Last Name">
							</div>
							<div class="col-md-6 col-sm-6 mb-3">
								<input type="text" name="phoneNumber" id="phoneNumber" class="form-control form-control-sm" autocomplete="OFF" placeholder="Phone Number">
							</div>
						</div>
						<div class="row mt-2">
							<div class="col-md-4 col-sm-4"> <hr> </div>
							<div class="col-md-4 col-sm-4 text-center">
								<h5>User Roles</h5>
							</div>
							<div class="col-md-4 col-sm-4"> <hr> </div>
						</div>
						<div class="row mt-2">
							<div class="col-md-6 col-sm-6 mb-3">
								<select name="access" id="access" class="form-select form-select-sm">
									<option>Choose Access</option>
									<option value="Accountant">Accountant</option>
									<option value="Supervisor">Supervisor</option>
									<option value="Teacher">Teacher</option>
								</select>
							</div>
							<div class="col-md-6 col-sm-6 mb-3">
								<select name="leader" id="leader" class="form-select form-select-sm">
									<option>Choose Role</option>
									<option value="normal Pr">Normal</option>
									<option value="Language Pr">Language</option>
									<option value="Mathematics Pr">Mathematics</option>
									<option value="Science Pr">Science</option>
									<option value="Social Studies Pr">Social Studies</option>
								</select>
							</div>
						</div>
						<div class="row mt-2">
							<div class="col-md-3 col-sm-3"> <hr> </div>
							<div class="col-md-6 col-sm-6 text-center">
								<h5 class="w-100">Subjects & Classes</h5>
							</div>
							<div class="col-md-3 col-sm-3"> <hr> </div>
						</div>
						<input type="hidden" name="page" value="admin">
						<input type="hidden" name="action" value="users">
						<input type="hidden" name="function" value="addUsers">
						<div class="row mt-2">
							<div class="col-md-6 col-sm-6">
								<label for="classNames" class="mb-3 fw-bold">Classes</label>
								<select name="classes[]" id="classNames" class="form-select form-select-sm" multiple>
									<?php
										$query = $conn->query("SELECT * FROM `classes`");

										while($fetch = $query->fetch_assoc()) {
											$classID = $fetch['Class_ID'];
											$level = $fetch['level'];
											$class = $fetch['Class_Name'];

											echo "<option value=\"$classID\">".$class."</option>";
										}
									?>
								</select>
							</div>
							<div class="col-md-6 col-sm-6">
								<label for="subjectNames" class="mb-3 fw-bold">Subjects</label>
								<div class="row">
									<?php
										$query = $conn->query("SELECT * FROM `subjects`");

										while($fetch = $query->fetch_assoc()) {
											$subjectID = $fetch['Subject_ID'];
											$subject = $fetch['Subject_Name'];

									?>
									
									<div class="col-md-4 col-sm-4">
										<div class="input-group">
											<div class="input-group-prepend">
												<div class="input-group-text">
													<input type="radio" name="subjects" id="subjects" value="<?php echo $subjectID; ?>" aria-label="<?php echo $subject; ?>" />
												</div>
											</div>
											<?php echo "  ".$subject; ?>
										</div>
									</div>
									<?php
											
										}
									?>
								</div>
							</div>
							<div class="col-md-6 mt-3">
								<button type="submit" class="btn btn-outline-info btn-sm w-100 fw-bold">
									<i class="text-danger fa fa-user-plus"></i>
									Add User
								</button>
							</div>
						</div>
					</form>
					<?php
				}

				if($_POST['function'] == "addUsers"){
					$fname = stripslashes(strip_tags($conn->real_escape_string($_POST['fname'])));
					$lname = stripslashes(strip_tags($conn->real_escape_string($_POST['lname'])));
					$phone = stripslashes(strip_tags($conn->real_escape_string($_POST['phoneNumber'])));
					$access = stripslashes(strip_tags($conn->real_escape_string($_POST['access'])));
					$leader = stripslashes(strip_tags($conn->real_escape_string($_POST['leader'])));
					$classes = $_POST['classes'];
					$subjects = stripslashes(strip_tags($conn->real_escape_string($_POST['subjects'])));

					$classes = implode(',', $_POST['classes']);

					$pass = substr($fname, 0 ,3).substr($lname, 0 ,3).substr($phone, 0 ,3);
					$shuffledChars = str_shuffle($pass);

					$length = rand(7, 10);
					$symbols = "!@#%^&*()";

					$randomSymbol = $symbols[rand(0, strlen($symbols) - 1)];

					$upass = $shuffledChars . $randomSymbol;

					while(strlen($upass) < 7) {
						$upass .= chr(rand(97, 122)); // Adding random lowercase ASCII characters
					}

					if(strlen($upass) > 10) {
						$upass = substr($upass, 0, 10);
					}
					
					$salt1 = "ELIMIKA";
					$salt2 = "DIGITAL";
					$password = crypt($upass, $salt1);
					$password = $salt1.md5($password).$salt2;

					$pass = password_hash($password, PASSWORD_BCRYPT);

					//check if user is there
					$query = $conn->query("SELECT * FROM `users` WHERE `FirstName`='$fname' AND `LastName` = '$lname' AND `Access`='$access'");
					$rows = $query->num_rows;

					if ($rows < 1) {
						// insert users in the database
						$query = $conn->query("INSERT INTO `users` (`FirstName`, `LastName`, `Access`, `Phone`, `upass`) VALUES ('$fname', '$lname', '$access', '$phone', '$pass')");


						// get users ID 
						$query = $conn->query("SELECT * FROM `users` WHERE `FirstName`='$fname' AND `LastName`='$lname' AND `Access`='$access'");
						$fetch = $query->fetch_assoc();

						$userID = $fetch['UID'];

						// insert into respective database tables
						if ($access = "Teacher") {
							$db = "teachers";
						}

						if ($query = $conn->query("INSERT INTO `$db` (`UID`, `Subject_IDs`, `Class_IDs`, `teacher_Access`) VALUES ('$userID', '$subjects', '$classes', '$leader')")){
							// send normal texts here

							if (substr($phone, 0, 1) === '0') {
								// Remove the leading 0 and replace it with 255
								$phone = '255' . substr($phone, 1);
							} else {
								$phone = '255'.$phone;
							}

							$curl = curl_init();

							curl_setopt_array($curl, array(
							CURLOPT_URL => 'https://messaging-service.co.tz/api/sms/v1/text/single',
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => '',
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 0,
							CURLOPT_FOLLOWLOCATION => true,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_CUSTOMREQUEST => 'POST',
							CURLOPT_POSTFIELDS =>'{"from":"Elimika", "to":"'.$phone.'",  "text": "Hello '.$fname.' \nYour Elimika Digital Account has been created \nUsername: Your Phone \nPassword: '.$upass.' \nAfter login please update your password.", "reference": "aswqetgcv"}',
							CURLOPT_HTTPHEADER => array(
								'Authorization: Basic YmVyZWdlOmp5enQ5OHFxbnpkOWdIVg==',
								'Content-Type: application/json',
								'Accept: application/json'
							),
							));

							$response = curl_exec($curl);

							curl_close($curl);
							// echo $response;
							
							echo "<span class=\"text-success\">".$lname." added & text sent.</span>";
						}

					} else {
						echo "<span class=\"text-warning\"><i class=\"text-danger fa fa-ban\"></i> User already Exists</span>";
					}
					
				}
			}

			if ($action == "exams") {
				if ($_POST['function'] == "addExams") {
					$examName = ucfirst(strip_tags(stripslashes($conn->real_escape_string($_POST['examName']))));
					$class = strip_tags(stripslashes($conn->real_escape_string($_POST['classes'])));
					$examType = strip_tags(stripslashes($conn->real_escape_string($_POST['examType'])));
					$time = strip_tags(stripslashes($conn->real_escape_string($_POST['examTimer'])));
					$date = date('y/M/d');

					$query = $conn->query("SELECT * FROM `exams` WHERE `Exam_Name`='$examName' AND `Class_ID`='$class'");
					$rows = $query->num_rows;

					if ($rows >= 1) {
						echo "Already exists";
					} else {
						$rows = $rows + 1;
						if($conn->query("INSERT INTO `exams` (`Exam_No`, `Class_ID`, `Exam_Name`, `Created_Date`, `Exam_Timer`, `Exam_Type`, `Status`) VALUES ('$rows', '$class', '$examName', '$date', '$time', '$examType', 'Pending')")){
							?>
							<div class="row mt-2 mb-3">
								<div class="col-sm-8 col-md-10">
									<input type="text" name="search" class="form-control form-control-sm searchIcon w-100" placeholder="Search Exams">
								</div>
								<div class="col-sm-4 col-md-2">
									<button type="button" class="btn btn-sm btn-rounded btn-outline-primary w-100" id="searchExamBtn">
										<i class="fa fa-search"></i>
										Search
									</button>
								</div>
							</div>
							<div class="row">
								<div class="col-md-2 col-sm-2 fw-bold">
									S/No
								</div>
								<div class="col-md-3 col-sm-3 fw-bold">
									Exam Name
								</div>
								<div class="col-md-2 col-sm-2 fw-bold">
									Created
								</div>
								<div class="col-md-2 col-sm-2 fw-bold">
									Status
								</div>
								<div class="col-sm-3 col-md-3 fw-bold">
									Action
								</div>
							</div>
							<?php
							$no = 0;

							$query = $conn->query("SELECT * FROM `exams` ORDER BY `Exam_ID` DESC");
							
							while ($fetch = $query->fetch_assoc()) {
								$examName = $fetch['Exam_Name'];
								$examNo = $fetch['Exam_No'];
								$created = $fetch['Created_Date'];
								$examID = $fetch['Exam_ID'];
								$status = $fetch['Status'];
								$no = $no + 1;

								?>
								<div class="row mb-4">
									<div class="col-md-2 col-sm-2 text-center">
										<?php echo $no; ?>
									</div>
									<div class="col-md-3 col-sm-3 text-center">
										<p class="text-start ts-9 w-100">
											<?php echo $examName; ?>
										</p>
									</div>
									<div class="col-md-2 col-sm-2">
										<p class="text-center ts-8">
											<?php echo $created; ?>
										</p>
									</div>
									<div class="col-md-2 col-sm-2">
										<?php
											if ($status == "Pending") {
												echo "<p class=\"text-warning ts-9\">$status</p>";
											}
											
											if ($status == "Published") {
												echo "<p class=\"text-success ts-9\">$status</p>";
											}
											
											if ($status == "Cancelled") {
												echo "<p class=\"text-danger ts-9\">Deleted</p>";
											}
										?>
									</div>
									<div class="col-sm-3 col-md-3">
										<button type="button" class="btn btn-sm btn-outline-danger deleteExam" dataID="<?php echo $examID; ?>">
											<i class="fa fa-trash"></i>
											Delete
										</button>
										<button type="button" class="btn btn-sm btn-outline-info openExam" dataID="<?php echo $examID; ?>">
											<i class="fa fa-eye"></i>
											Open
										</button>
									</div>
								</div>
								<?php

							}
						}

					}

				}

				if ($_POST['function'] == "examAction") {
					?>
					<button type="button" class="btn btn-sm btn-outline-primary" id="showExams">
						<i class="fa fa-eye"></i>
						Show Exams
					</button>
					
					<div class="mt-3 mb-3" id="container">
						<form class="form" id="addExam">
							<div class="row mb-2">
								<div class="col-sm-6 col-md-4">
									<div class="form-floating">
										<input type="text" name="examName" id="examName" class="form-control form-control-sm" required/>
										<label for="formInput">Exam Name</label>
									</div>
								</div>
								<div class="col-md-2 col-sm-6">
									<div class="form-floating w-100">
										<select name="classes" class="form-select w-100">
											<option value=""></option>
											<?php
												$query = $conn->query("SELECT * FROM `classes` ORDER BY `Class_Name` ASC");
												while ($fetch = $query->fetch_assoc()) {
													$className = $fetch['Class_Name'];
													$level = $fetch['Level'];
													$classID = $fetch['Class_ID'];

													?>
													<option value="<?php echo $classID; ?>"><?php echo $className; ?></option>
													<?php
												}
											?>
										</select>
										<label for="formSelect">Classes</label>
									</div>
								</div>
								<div class="col-md-2 col-sm-6">
									<div class="form-check">
										<input type="radio" name="examType" id="examType" value="Free" checked>
										<label class="text-primary fw-bold">Free</label>
									</div>
									<div class="form-check">
										<input type="radio" name="examTimer" id="examTimer" value="Paid">
										<label class="text-danger fw-bold">Paid</label>
									</div>
								</div>

								<input type="hidden" name="page" value="admin">
								<input type="hidden" name="action" value="exams">
								<input type="hidden" name="function" value="addExams">
								
								<div class="col-md-2 col-sm-6">
									<div class="form-check">
										<input type="radio" name="examTimer" value="No" checked>
										<label class="text-primary fw-bold">No Timer</label>
									</div>
									<div class="form-check">
										<input type="radio" name="examTimer" value="Yes">
										<label class="text-danger fw-bold">Yes Timer</label>
									</div>
								</div>
								<div class="col-md-2 col-sm-12">
									<button type="submit" class="btn btn-sm btn-outline-primary w-100">
										<i class="fa fa-paper-plane"></i>
										Submit
									</button>
								</div>
							</div>
						</form>
						
						<div class="table-responsive" id="examData">
					
					<?php

					$query = $conn->query("SELECT * FROM `exams` ORDER BY `Exam_Name`, `Status` ASC");
					$rows = $query->num_rows;
					
					if($rows < 1){
						echo "<span class=\"text-warning fw-bold\">No Exams in the database. </span>";
					} else {
						$no = 0;
						?>
						<div class="row mt-2 mb-3">
							<div class="col-sm-8 col-md-10">
								<input type="text" name="search" class="form-control form-control-sm searchIcon w-100" placeholder="Search Exams">
							</div>
							<div class="col-sm-4 col-md-2">
								<button type="button" class="btn btn-sm btn-rounded btn-outline-primary w-100" id="searchExamBtn">
									<i class="fa fa-search"></i>
									Search
								</button>
							</div>
						</div>
						<div class="row">
							<div class="col-md-2 col-sm-2 fw-bold">
								S/No
							</div>
							<div class="col-md-3 col-sm-3 fw-bold">
								Exam Name
							</div>
							<div class="col-md-2 col-sm-2 fw-bold">
								Created
							</div>
							<div class="col-md-2 col-sm-2 fw-bold">
								Status
							</div>
							<div class="col-sm-3 col-md-3 fw-bold">
								Action
							</div>
						</div>
						
						<?php

						while ($fetch = $query->fetch_assoc()){
							$examName = $fetch['Exam_Name'];
							$examNo = $fetch['Exam_No'];
							$created = $fetch['Created_Date'];
							$examID = $fetch['Exam_ID'];
							$status = $fetch['Status'];
							$no = $no + 1;
						?>
						<div class="row">
							<div class="col-md-2 col-sm-2 text-center">
								<?php echo $no; ?>
							</div>
							<div class="col-md-3 col-sm-3 text-center">
								<p class="text-start ts-9 w-100">
									<?php echo $examName; ?>
								</p>
							</div>
							<div class="col-md-2 col-sm-2">
								<p class="text-center ts-8">
									<?php echo $created; ?>
								</p>
							</div>
							<div class="col-md-2 col-sm-2">
								<?php
									if ($status == "Pending") {
										echo "<p class=\"text-warning ts-9\">$status</p>";
									}
									
									if ($status == "Published") {
										echo "<p class=\"text-success ts-9\">$status</p>";
									}
									
									if ($status == "Cancelled") {
										echo "<p class=\"text-danger ts-9\">Deleted</p>";
									}
								?>
							</div>
							<div class="col-sm-3 col-md-3">
								<button type="button" class="btn btn-sm btn-outline-danger deleteExam" dataID="<?php echo $examID; ?>">
									<i class="fa fa-trash"></i>
									Delete
								</button>
								<button type="button" class="btn btn-sm btn-outline-info openExam" dataID="<?php echo $examID; ?>">
									<i class="fa fa-eye"></i>
									Open
								</button>
							</div>
						</div>
						<?php
						}
					}
					?>
							
					</div>
					<div class="row mt-4" id="examRows"></div>

					<?php

				}

				if ($_POST['function'] == "examProfile") {
					$examID = stripslashes(strip_tags($conn->real_escape_string($_POST['examID'])));

					$query = $conn->query("SELECT * FROM `exams` WHERE `Exam_ID`='$examID'");
					$fetch = $query->fetch_assoc();

					$examID = $fetch['Exam_ID'];
					$examName = $fetch['Exam_Name'];
					$classIDs = $fetch['Class_ID'];
					$created = $fetch['Created_Date'];
					
					if($classIDs != 0){
						$query = $conn->query("SELECT * FROM `classes` WHERE `Class_ID`='$classIDs'");
						$fetch = $query->fetch_assoc();

						$className = $fetch['Class_Name'];
					} else {
						$className = "All";
					}

					//Check subjects assigned to exams
					$queryS = $conn->query("SELECT * FROM `exam_subject_section` WHERE `exam_ID`='$examID'");
					$assignedSubs = $queryS->num_rows;

					// Check assigned questions
					$queryQ = $conn->query("SELECT * FROM `questions` WHERE `Exam_ID`='$examID'");
					$assignedQns = $queryQ->num_rows;

					?>
					<div class="row">
						<div class="col-md-12 col-sm-12 mb-2 mt-3">
							<h5>
								<?php echo $examName; ?>
							</h5>
						</div>
					</div>
					<div class="row">
						<div class="col-md-3 col-sm-3 text-center bordered">
							<span class="fw-bold">Class:</span> <br>
							<?php echo $className; ?>
						</div>
						<div class="col-md-3 col-sm-3 text-center bordered">
							<span class="fw-bold">Subjects:</span> <br>
							<?php echo $assignedSubs; ?>
						</div>
						<div class="col-md-3 col-sm-3 text-center bordered">
							<span class="fw-bold">Questions:</span> <br>
							<?php echo $assignedQns; ?>
						</div>
						<div class="col-md-3 col-sm-3 text-center bordered">
							<span class="fw-bold">Students:</span> <br>
							<?php echo $assignedQns; ?>
						</div>
					</div>

					<div class="row mb-2 mt-4 examsManipulation">
						<?php
							if($assignedSubs >= 1){
								while($fetch = $queryS->fetch_assoc()){
									$subjectID = $fetch['subject_ID'];
									
									$query = $conn->query("SELECT * FROM `subjects` WHERE `Subject_ID`='$subjectID'");
									$fetch = $query->fetch_assoc();
									$subjectName = $fetch['Subject_Name'];
						?>

						<div class="mb-2 col-md-3 col-sm-<?php if($subjectName == "Civic And Moral Education" || $subjectName == "Science And Technology") { echo 5; } else { echo 4; } ?>">
							<button type="button" style="width: 100%;" class="btn btn-outline-primary" id="subjectExamBtn" subjectID="<?php echo $subjectID; ?>" examID="<?php echo $examID; ?>">
								<span class="<?php if($subjectName == "Civic And Moral Education" || $subjectName == "Science And Technology") { echo "ts-8"; } ?>">
									<?php echo $subjectName; ?>
								</span>
							</button>
						</div>
						
						<?php
								}
							}
						?>

						<div class="col-md-3 col-sm-4 mb-3">
							<button type="button" class="btn btn-outline-info w-100" id="addExamSubjects" examID="<?php echo $examID; ?>">
								<i class="fa fa-plus"></i>
								Add Subjects
							</button>
						</div>
						<div class="row mb-3 mt-3" id="examSectionManipulation"></div>
					</div>
					<?php
				
				}

				if ($_POST['function'] == "showSubjectForm") {
					$examID = stripslashes(strip_tags($conn->real_escape_string($_POST['examID'])));

					?>
					<form class="form" id="examSubjectForm">
						<div class="row mb-2">
							<div class="col-6">
								<?php
									subjectSelect();
								?>
							</div>
							<div class="col-6">
								<div class="form-floating">
									<input type="number" name="section" class="form-control form-control-sm">
									<label class="fw-bold">Number Of Sections</label>
								</div>
							</div>
						</div>
						<div class="row mb-3">
							<div class="col-12 fw-bold text-center mb-3">
								List of Sections
							</div>
							<div class="col-12 mb-2 secionA">
								<div class="row mb-2">
									<div class="col-3">
										<h5>1.</h5>
									</div>
									<div class="col-9">
										<h5>Section A</h5>
									</div>
								</div>
								<div class="row mb-2">
									<div class="col-8">
										<div class="form-floating">
											<input type="text" name="sectionAInstruction" class="form-control">
											<label>Section Instructions</label>
										</div>
									</div>
									<div class="col-2">
										<div class="form-floating">
											<input type="number" name="sectionAMarks" class="form-control">
											<label>Marks</label>
										</div>
									</div>
									<div class="col-2">
										<div class="form-floating">
											<input type="number" name="sectionAParts" class="form-control">
											<label>Parts</label>
										</div>
									</div>
								</div>
							</div>
							<div class="col-12 mb-2 secionB">
								<div class="row mb-2">
									<div class="col-3">
										<h5>2.</h5>
									</div>
									<div class="col-9">
										<h5>Section B</h5>
									</div>
								</div>
								<div class="row mb-2">
									<div class="col-8">
										<div class="form-floating">
											<input type="text" name="sectionBInstruction" class="form-control">
											<label>Section Instructions</label>
										</div>
									</div>
									<div class="col-2">
										<div class="form-floating">
											<input type="number" name="sectionBMarks" class="form-control">
											<label>Marks</label>
										</div>
									</div>
									<div class="col-2">
										<div class="form-floating">
											<input type="number" name="sectionBParts" class="form-control">
											<label>Parts</label>
										</div>
									</div>
								</div>
							</div>
							<div class="col-12 mb-2 secionC">
								<div class="row mb-2">
									<div class="col-3">
										<h5>3.</h5>
									</div>
									<div class="col-9">
										<h5>Section C</h5>
									</div>
								</div>
								<div class="row mb-2">
									<div class="col-8">
										<div class="form-floating">
											<input type="text" name="sectionCInstruction" class="form-control">
											<label>Section Instructions</label>
										</div>
									</div>
									<div class="col-2">
										<div class="form-floating">
											<input type="number" name="sectionCMarks" class="form-control">
											<label>Marks</label>
										</div>
									</div>
									<div class="col-2">
										<div class="form-floating">
											<input type="number" name="sectionCParts" class="form-control">
											<label>Parts</label>
										</div>
									</div>
								</div>
							</div>
						</div>
						<input type="hidden" name="page" value="admin">
						<input type="hidden" name="action" value="exams">
						<input type="hidden" name="function" value="addSubjectSections">
						<input type="hidden" name="examID" value="<?php echo $examID; ?>">
						<div class="row text-center">
							<button type="submit" class="btn btn-sm btn-outline-info fw-bold">
								<i class="fa fa-paper-plane"></i>
								Add Details
							</button>
						</div>
					</form>
					<?php
				}

				if($_POST['function'] == "addSubjectSections") {
					$examID = strip_tags(stripslashes($conn->real_escape_string($_POST['examID'])));
					$sectionNo = strip_tags(stripslashes($conn->real_escape_string($_POST['section'])));
					$subjectID = strip_tags(stripslashes($conn->real_escape_string($_POST['subjects'])));

					//Section A
					$instructionsA = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionAInstruction'])));
					$partsA = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionAParts'])));
					$marksA = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionAMarks'])));

					//Section B
					$instructionsB = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionBInstruction'])));
					$partsB = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionBParts'])));
					$marksB = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionBMarks'])));

					//Section C
					$instructionsC = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionCInstruction'])));
					$partsC = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionCParts'])));
					$marksC = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionCMarks'])));

					// check if exam subject already exists
					$query = $conn->query("SELECT * FROM `exam_subject_section` WHERE `subject_ID` = '$subjectID' AND `exam_ID`='$examID'");
					$rows = $query->num_rows;

					if($rows >= 1){
						echo "<span class=\"text-danger fw-bold\">Subject for exam already exists</span>";
					} else {
						//insert subject in database
						$query = $conn->query("INSERT INTO `exam_subject_section` (`subject_ID`, `section_Nos`, `exam_ID`) VALUE ('$subjectID', '$sectionNo', '$examID')");

						//get Section Subject ID
						$query = $conn->query("SELECT * FROM `exam_subject_section` WHERE `subject_ID`='$subjectID' AND `exam_ID`='$examID'");
						$fetch = $query->fetch_assoc();
						$ID = $fetch['id'];

						$sql = "INSERT INTO `exam_sections`(`exam_subject_section_ID`, `section_No`, `section_Instruction`, `section_Marks`, `totalParts`) VALUES";
						 
						$sql .= "('$ID', '1', '$instructionsA', '$marksA', '$partsA')";

						if (!empty($instructionsB)) {
							$sql .= ", ('$ID', '2', '$instructionsB', '$marksB', '$partsB')";
						}

						if (!empty($instructionsC)) {
							$sql .= ", ('$ID', '3', '$instructionsC', '$marksC', '$partsC')";
						}

						$query = $conn->query($sql);
					}
				}

				if ($_POST['function'] == "showSubjectExamTable") {
					$examID = strip_tags(stripslashes($conn->real_escape_string($_POST['examID'])));
					$subjectID = strip_tags(stripslashes($conn->real_escape_string($_POST['subjectID'])));

					$query = $conn->query("SELECT * FROM `exam_subject_section` WHERE `subject_ID`='$subjectID' AND `exam_ID`='$examID'");
					$fetch = $query->fetch_assoc();
					
					$examSubID = $fetch['id'];

					$query = $conn->query("SELECT * FROM `exam_sections` WHERE `exam_subject_section_ID`='$examSubID'");
					?>
					<div class="row">
						<div class="row mb-3 fw-bold">
							<div class="col-md-4 col-sm-4">
								Sections
							</div>
							<div class="col-md-4 col-sm-4">
								Parts
							</div>
							<div class="col-md-4 col-sm-4">
								Action
							</div>
						</div>
					<?php
					while ($fetch = $query->fetch_assoc()) {
						$sectionID = $fetch['section_ID'];
						$examSubjectID = $fetch['exam_subject_section_ID'];
						$sectionNo = $fetch['section_No'];
						$instruction = $fetch['section_Instruction'];
						$sectionMarks = $fetch['section_Marks'];
						$parts = $fetch['totalParts'];

						//check the number of parts in particular questions
						$querySections = $conn->query("SELECT * FROM `section_parts` WHERE `examSectionID`='$sectionID'");
						$partsNo = $querySections->num_rows;

						?>
						<div class="row mb-2">
							<div class="col-4">
								<?php
									$sectionNo = chr(64 + $sectionNo);
									echo "<span class=\"fw-bold\"> Section ".$sectionNo."</span>";
								?>
							</div>
							<div class="col-4">
								<?php echo $partsNo." Parts"; ?>
							</div>
							<div class="col-4">
								<button type="button" class="btn btn-sm btn-outline-info w-100" id="viewExams" 
										subjectID="<?php echo $subjectID; ?>" sectionID="<?php echo $sectionID; ?>" 
										totalParts="<?php echo $parts; ?>">
									<i class="fa fa-eye"></i>
									View Exam
								</button>
							</div>
						</div>
						<?php
					}
					?>
					</div>
					<?php
				}

				if ($_POST['function'] == "addPartsQuestion") {
					$parts = stripslashes(strip_tags($conn->real_escape_string($_POST['parts'])));
					$sectionID = stripslashes(strip_tags($conn->real_escape_string($_POST['sectionID'])));
					$subjectID = stripslashes(strip_tags($conn->real_escape_string($_POST['subjectID'])));

					$query = $conn->query("SELECT * FROM `section_parts` WHERE `examSectionID`='$sectionID'");
					$rows = $query->num_rows;

					if($rows < 1){

						// insert into section parts
						for ($i=1; $i <= $parts ; $i++) {
							$conn->query("INSERT INTO `section_parts` (`examSectionID`, `sectionPartTitle`, `sectionPartQuestions`, `sectionPartMarks`, `sectionPartType`, `sectionPartImage`, `sectionPartPassage`)
							VALUES ('$sectionID', ' ', ' ', ' ','',' ', ' ')");
						}

						$query = $conn->query("SELECT * FROM `section_parts` WHERE `examSectionID`='$sectionID'");
						$rows = $query->num_rows;
						$no = 0;

						while ($fetch = $query->fetch_assoc()) {
							$sectionID = $fetch['examSectionID'];
							$sectionPartID = $fetch['sectionPartID'];
							$no = $no + 1;

							?>
							<div sectionID="<?php echo $sectionID; ?>" sectionPartID="<?php echo $sectionPartID; ?>" class="<?php if($parts >= 3){ echo "col-4"; } if($parts == 2){ echo "col-6"; } if($parts == 1){ echo "col-12"; } ?>" id="examPart">
								<button type="button" class="btn btn-sm btn-outline-info w-100 fw-bold"> Part <?php echo $no; ?> </button>
							</div>
							<?php
						}
					} else {

						$no = 0;

						while ($fetch = $query->fetch_assoc()) {
							$sectionID = $fetch['examSectionID'];
							$sectionPartID = $fetch['sectionPartID'];
							$no = $no + 1;

							?>
							<div class="<?php if($parts >= 3){ echo "col-4"; } if($parts == 2){ echo "col-6"; } if($parts == 1){ echo "col-12"; } ?>">
								<button type="button" class="btn btn-sm btn-outline-info w-100 fw-bold" id="examPart" sectionID="<?php echo $sectionID; ?>" sectionPartID="<?php echo $sectionPartID; ?>" > Part <?php echo $no; ?> </button>
							</div>
							<?php
						}
					}

					?>
					<div class="col-12 mt-2">
						<div class="row" id="partsDiv"></div>
						<!-- <div class="row" id="qnsDiv"></div> -->
					</div>
					<?php

				}

				if($_POST['function'] == "showQuestions"){

					if(isset($_POST['partTitle'])){
						$title = stripslashes(strip_tags($conn->real_escape_string($_POST['partTitle'])));
						$qns = stripslashes(strip_tags($conn->real_escape_string($_POST['partQns'])));
						$marks = stripslashes(strip_tags($conn->real_escape_string($_POST['partMarks'])));
						$sectionPartID = stripslashes(strip_tags($conn->real_escape_string($_POST['sectionPartID'])));
						$image = stripslashes(strip_tags($conn->real_escape_string($_POST['image'])));
						$passage = stripslashes(strip_tags($conn->real_escape_string($_POST['passage'])));
						$type = stripslashes(strip_tags($conn->real_escape_string($_POST['partType'])));

						$query = $conn->query("UPDATE `section_parts` SET `sectionPartTitle`='$title', `sectionPartQuestions`='$qns', 
						`sectionPartMarks`='$marks', `sectionPartType`='$type', `sectionPartImage`='$image', `sectionPartPassage`='$passage' 
						WHERE `sectionPartID`='$sectionPartID'");

						$sectionID = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionID'])));
						
						$query = $conn->query("SELECT * FROM `section_parts` WHERE `sectionPartID`='$sectionPartID'");

						$fetch = $query->fetch_assoc();

						$title = $fetch['sectionPartTitle'];
						$qns = $fetch['sectionPartQuestions'];
						$marks = $fetch['sectionPartMarks'];
						$sectionType = $fetch['sectionPartType'];
						$image = $fetch['sectionPartImage'];
						$passage = $fetch['sectionPartPassage'];

						?>
						<form class="form mt-3" id="sectionTitleForm">
							<div class="row">
								<div class="col-8 mt-2">
									<div class="form-floating">
										<input type="text" name="partTitle" class="form-control" value="<?php echo $title; ?>">
										<label class="fw-bold">Question Title</label>
									</div>
								</div>
								<div class="col-2 mt-2">
									<div class="form-floating">
										<input type="number" name="partQns" class="form-control" value="<?php echo $qns; ?>">
										<label class="fw-bold">Qns</label>
									</div>
								</div>
								<div class="col-2 mt-2">
									<div class="form-floating">
										<input type="number" name="partMarks" class="form-control" value="<?php echo $marks; ?>">
										<label>Marks</label>
									</div>
								</div>
							</div>
							<input type="hidden" name="page" value="admin">
							<input type="hidden" name="action" value="exams">
							<input type="hidden" name="function" value="showQuestions">
							<input type="hidden" name="sectionPartID" value="<?php echo $sectionPartID; ?>">
							<input type="hidden" name="sectionID" value="<?php echo $sectionID; ?>">
							<div class="row">
								<div class="col-4 mt-2">
									<div class="form-floating">
										<select name="partType" class="form-select">
											<option></option>
											<option value="listening" <?php if($sectionType == "listening"){ echo "selected"; } ?>><?php echo strtoupper('listening');?></option>
											<option value="multiple choice" <?php if($sectionType == "multiple choice"){ echo "selected"; } ?>><?php echo strtoupper('multiple choice'); ?></option>
											<option value="matching items" <?php if($sectionType == "matching items"){ echo "selected"; } ?>><?php echo strtoupper('matching items'); ?></option>
											<option value="open questions" <?php if($sectionType == "open questions"){ echo "selected"; } ?>><?php echo strtoupper('open questions'); ?></option>
										</select>
										<label class="fw-bold">Question Type</label>
									</div>
								</div>
								<div class="col-2 mt-2">
									<span class="fw-bold">Image</span> <br>
									<input type="radio" name="image" class="form-radio" value="Yes" <?php if($image == "Yes"){ echo "checked"; } ?>> Yes
									<input type="radio" name="image" class="form-radio" value="No" <?php if($image == "No"){ echo "checked"; } ?>> No
								</div>
								<div class="col-2 mt-2">
									<div class="form-floating">
										<span class="fw-bold ts-8">Passage</span> <br>
										<input type="radio" name="passage" class="form-radio" value="Yes" <?php if($passage == "Yes"){ echo "checked"; } ?>> Yes
										<input type="radio" name="passage" class="form-radio" value="No" <?php if($passage == "No"){ echo "checked"; } ?>> No
									</div>
								</div>
								<div class="col-4 mt-3">
									<button type="submit" class="btn btn-outline-info w-100">Add Title</button>
								</div>
							</div>
						</form>
						<?php

					} else {

						$sectionID = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionID'])));
						$sectionPartID = strip_tags(stripslashes($conn->real_escape_string($_POST['sectionPartID'])));

						$query = $conn->query("SELECT * FROM `section_parts` WHERE `sectionPartID`='$sectionPartID'");
						
						$fetch = $query->fetch_assoc();

						$title = $fetch['sectionPartTitle'];
						$qns = $fetch['sectionPartQuestions'];
						$marks = $fetch['sectionPartMarks'];
						$sectionType = $fetch['sectionPartType'];
						$image = $fetch['sectionPartImage'];
						$passage = $fetch['sectionPartPassage'];
					
						?>
						<form class="form mt-4" id="sectionTitleForm">
							<div class="row">
								<div class="col-8 mt-2">
									<div class="form-floating">
										<input type="text" name="partTitle" class="form-control" value="<?php echo $title; ?>">
										<label class="fw-bold">Question Title</label>
									</div>
								</div>
								<div class="col-2 mt-2">
									<div class="form-floating">
										<input type="number" name="partQns" class="form-control" value="<?php echo $qns; ?>">
										<label class="fw-bold">Qns</label>
									</div>
								</div>
								<div class="col-2 mt-2">
									<div class="form-floating">
										<input type="number" name="partMarks" class="form-control" value="<?php echo $marks; ?>">
										<label>Marks</label>
									</div>
								</div>
							</div>
							<input type="hidden" name="page" value="admin">
							<input type="hidden" name="action" value="exams">
							<input type="hidden" name="function" value="showQuestions">
							<input type="hidden" name="sectionPartID" value="<?php echo $sectionPartID; ?>">
							<input type="hidden" name="sectionID" value="<?php echo $sectionID; ?>">
							<div class="row">
								<div class="col-4 mt-2">
									<div class="form-floating">
										<select name="partType" class="form-select">
											<option></option>
											<option value="listening" <?php if($sectionType == "listening"){ echo "selected"; } ?>><?php echo strtoupper('listening');?></option>
											<option value="multiple choice" <?php if($sectionType == "multiple choice"){ echo "selected"; } ?>><?php echo strtoupper('multiple choice'); ?></option>
											<option value="matching items" <?php if($sectionType == "matching items"){ echo "selected"; } ?>><?php echo strtoupper('matching items'); ?></option>
											<option value="open questions" <?php if($sectionType == "open questions"){ echo "selected"; } ?>><?php echo strtoupper('open questions'); ?></option>
										</select>
										<label class="fw-bold">Question Type</label>
									</div>
								</div>
								<div class="col-2 mt-2">
									<span class="fw-bold">Image</span> <br>
									<input type="radio" name="image" class="form-radio" value="Yes" <?php if($image == "Yes"){ echo "checked"; } ?>> Yes
									<input type="radio" name="image" class="form-radio" value="No" <?php if($image == "No"){ echo "checked"; } ?>> No
								</div>
								<div class="col-2 mt-2">
									<div class="form-floating">
										<span class="fw-bold ts-8">Passage</span> <br>
										<input type="radio" name="passage" class="form-radio" value="Yes" <?php if($passage == "Yes"){ echo "checked"; } ?>> Yes
										<input type="radio" name="passage" class="form-radio" value="No" <?php if($passage == "No"){ echo "checked"; } ?>> No
									</div>
								</div>
								<div class="col-4 mt-3">
									<button type="submit" class="btn btn-outline-info w-100">Add Title</button>
								</div>
							</div>
						</form>
					<?php
					}

				}

			}
		}
	}

?>